<?php

namespace FiloBlu\Esb\Api;

use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Class RetryStrategyResolverInterface
 * @package FiloBlu\Esb\Api
 */
interface RetryStrategyResolverInterface
{

    /**
     * @return RetryStrategyInterface[]
     */
    public function getAll();

    /**
     * Retrieve strategy by name or class name
     * @param string $name
     * @return mixed
     * @throws NoSuchEntityException
     */
    public function get(string $name): RetryStrategyInterface;

    /**
     * @return RetryStrategyInterface
     */
    public function getDefault() : RetryStrategyInterface;
}
