<?php

namespace FiloBlu\Esb\Api;

use FiloBlu\Esb\Api\Data\PublisherInterface;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Interface PublisherResolverInterface
 * @package FiloBlu\Esb\Api
 */
interface PublisherResolverInterface
{
    /**
     * @param $publisherCode
     * @return PublisherInterface
     * @throws NoSuchEntityException
     */
    public function get($publisherCode);

    /**
     * @return PublisherInterface
     * @throws NoSuchEntityException
     */
    public function getDefault();

    /**
     * @return mixed
     */
    public function getAll();
}
