<?php

namespace FiloBlu\Esb\Api;

use FiloBlu\Esb\Api\Data\ProducerInterface;

/**
 * Interface ResolverInterface
 * @package FiloBlu\Esb\Api
 */
interface ProducerResolverInterface
{
    /**
     * @param string $identifier
     * @return ProducerInterface
     */
    public function get($identifier): ProducerInterface;

    /**
     * @param string $identifier
     * @return bool
     */
    public function has($identifier): bool;

    /**
     * @return ProducerInterface[]
     */
    public function getAll(): array;
}
