<?php

namespace FiloBlu\Esb\Api\Data;

use FiloBlu\Esb\Api\RetryStrategyInterface;
use Magento\Framework\DataObject;

/**
 * Interface ProducerConfigurationInterface
 * @package FiloBlu\Esb\Api\Data
 */
interface ProducerConfigurationInterface extends IdentifiableInterface, RepositoryItem
{
    /** @var int */
    const STATUS_ENABLED = 1;
    /** @var int */
    const STATUS_DISABLED = 0;
    /** @var string */
    const PRODUCER = 'producer';
    /** @var string */
    const OUTPUT_EVENT = 'output_event';
    /** @var string */
    const PARAMETERS = 'parameters';
    /** @var string */
    const ENABLE = 'enable';
    /** @var string */
    const RETRY_STRATEGY = 'retry_strategy';
    /** @var string */
    const LABEL = 'label';
    /** @var string  */
    const PRIORITY = 'priority';

    /**
     * @return string
     */
    public function getOutputEvent(): string;

    /**
     * @param $event
     * @return ProducerConfigurationInterface
     */
    public function setOutputEvent($event): ProducerConfigurationInterface;

    /**
     * @return DataObject
     */
    public function getParameters(): DataObject;

    /**
     * @param DataObject $parameters
     * @return ProducerConfigurationInterface
     */
    public function setParameters(DataObject $parameters): ProducerConfigurationInterface;

    /**
     * @return ProducerInterface
     */
    public function getProducer(): ProducerInterface;

    /**
     * @param ProducerInterface $producer
     * @return ProducerConfigurationInterface
     */
    public function setProducer(ProducerInterface $producer): ProducerConfigurationInterface;

    /**
     * @return string
     */
    public function getLabel(): string;

    /**
     * @param string $label
     * @return ProducerConfigurationInterface
     */
    public function setLabel(string $label): ProducerConfigurationInterface;

    /**
     * @return bool
     */
    public function isEnabled(): bool;

    /**
     * @return mixed
     */
    public function enable();

    /**
     * @return mixed
     */
    public function disable();

    /**
     * @return RetryStrategyInterface
     */
    public function getRetryStrategy(): RetryStrategyInterface;

    /**
     * @param RetryStrategyInterface $retryStrategy
     * @return ProducerConfigurationInterface
     */
    public function setRetryStrategy(RetryStrategyInterface $retryStrategy): ProducerConfigurationInterface;

    /**
     * @param int $priority
     * @return ProducerConfigurationInterface
     */
    public function setPriority(int $priority) : ProducerConfigurationInterface;

    /**
     * @return int
     */
    public function getPriority() : int;
}
