<?php

namespace FiloBlu\Esb\Api\Data;

/**
 * Interface EventConfigurationInterface
 * @package FiloBlu\Esb\Api\Data
 */
interface EventConfigurationInterface extends IdentifiableInterface, RepositoryItem
{
    /** @var string */
    const EVENT_CODE = 'event_code';

    /** @var string */
    const BASE_EVENT = 'base_event';

    /** @var string */
    const LABEL = 'label';

    /**
     * @return string
     */
    public function getLabel(): string;

    /**
     * @param $label
     * @return EventConfigurationInterface
     */
    public function setLabel(string $label): EventConfigurationInterface;

    /**
     * @return mixed
     */
    public function getEventCode();

    /**
     * @param string $eventCode
     * @return EventConfigurationInterface
     */
    public function setEventCode(string $eventCode): EventConfigurationInterface;

    /**
     * @return EventInterface
     */
    public function getBaseEvent(): EventInterface;

    /**
     * @param EventInterface $baseEvent
     * @return EventConfigurationInterface
     */
    public function setBaseEvent(EventInterface $baseEvent): EventConfigurationInterface;
}
