<?php

namespace FiloBlu\Esb\Ui\Component\Queue\Listing\Column;

use FiloBlu\Esb\Api\Data\EventConfigurationInterface;
use FiloBlu\Esb\Api\Data\QueueItemInterface;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class Actions
 * @package FiloBlu\Esb\Ui\Component\Queue\Listing\Column
 */
class Actions extends Column
{
    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $item[$this->getData('name')] = [
                    'edit' => [
                        'href' => $this->context->getUrl(
                            'esb/queue/view',
                            ['id' => $item[QueueItemInterface::ID]]
                        ),
                        'label' => __('view')
                    ]
                ];
            }
        }

        return $dataSource;
    }
}
