<?php

namespace FiloBlu\Esb\Ui\Component\Consumer\Listing;

use FiloBlu\Esb\Api\ConsumerConfigurationRepositoryInterface;
use FiloBlu\Esb\Ui\Component\AbstractDataProvider;
use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\Search\SearchCriteriaBuilder;
use Magento\Framework\App\RequestInterface;

/**
 * Class DataProvider
 * @package FiloBlu\Esb\Ui\Component\Producer\Listing
 */
class DataProvider extends AbstractDataProvider
{

    /**
     * @var ConsumerConfigurationRepositoryInterface
     */
    protected $itemRepository;

    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param ConsumerConfigurationRepositoryInterface $itemRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param FilterBuilder $filterBuilder
     * @param RequestInterface $request
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        ConsumerConfigurationRepositoryInterface $itemRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        FilterBuilder $filterBuilder,
        RequestInterface $request,
        array $meta = [],
        array $data = []
    )
    {
        parent::__construct($name,
            $primaryFieldName,
            $requestFieldName,
            $searchCriteriaBuilder,
            $filterBuilder,
            $request,
            $meta,
            $data);
        $this->itemRepository = $itemRepository;
    }

    /**
     * @inheritDoc
     */
    public function getData()
    {
        $result = $this->itemRepository->getList($this->getSearchCriteria(), true);

        return [
            'items'        => $result->getItems(),
            'totalRecords' => $result->getTotalCount()
        ];
    }

    /**
     * @inheritDoc
     */
    public function getSearchResult()
    {
        $searchCriteria = $this->getSearchCriteria();
        return $this->itemRepository->getList($searchCriteria);
    }
}
