<?php

namespace FiloBlu\Esb\Ui\Component\Consumer\Form;

use FiloBlu\Esb\Api\ConsumerConfigurationRepositoryInterface;
use FiloBlu\Esb\Api\Data\ConsumerConfigurationInterface;
use FiloBlu\Esb\Ui\Component\AbstractDataProvider;
use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\Search\SearchCriteriaBuilder;
use Magento\Framework\App\RequestInterface;

/**
 * Class DataProvider
 * @package FiloBlu\Esb\Ui\Component\Consumer\Form
 */
class DataProvider extends AbstractDataProvider
{

    /**
     * @var ConsumerConfigurationRepositoryInterface
     */
    protected $itemRepository;
    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param ConsumerConfigurationRepositoryInterface $itemRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param FilterBuilder $filterBuilder
     * @param RequestInterface $request
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        ConsumerConfigurationRepositoryInterface $itemRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        FilterBuilder $filterBuilder,
        RequestInterface $request,
        array $meta = [],
        array $data = []
    )
    {
        parent::__construct
        (
            $name,
            $primaryFieldName,
            $requestFieldName,
            $searchCriteriaBuilder,
            $filterBuilder,
            $request,
            $meta,
            $data
        );
        $this->itemRepository = $itemRepository;
        $this->request = $request;
    }

    /**
     * @inheritDoc
     */
    public function getData()
    {
        $data = [];

        $type = $this->request->getParam('type', null);

        if ($type !== null) {
            return [
                null => [
                    'general' => [
                        'consumer' => [
                            ConsumerConfigurationInterface::CONSUMER   => $type,
                            ConsumerConfigurationInterface::PARAMETERS => '{"conditions": [] , "payload":{} }'
                        ]
                    ]
                ]
            ];
        }

        $result = $this->itemRepository->getList($this->getSearchCriteria(), true);

        // @see \Magento\Ui\Component\Form
        foreach ($result->getItems() as $item) {
            $data[$item[$this->primaryFieldName]]['general']['consumer'] = $item;
        }
        return $data;
    }

    /**
     * @inheritDoc
     */
    public function getSearchResult()
    {
        $searchCriteria = $this->getSearchCriteria();
        return $this->itemRepository->getList($searchCriteria);
    }
}
