<?php
declare(strict_types=1);
/**
 * Copyright © 2016 FiloBlu S.r.l. All rights reserved.
 */

namespace FiloBlu\Esb\Observer;

use Exception;
use FiloBlu\Esb\Api\Data\EventInterface;
use FiloBlu\Esb\Framework\Event\EventEmitter;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\Order\Shipment;

/**
 * Observer on Order Status Update
 */
class SalesOrderShipmentSaveAfter implements ObserverInterface
{
    /**
     * @var EventEmitter
     */
    private $eventEmitter;

    /**
     * @var EventInterface
     */
    private $eventToEmit;

    /**
     * OrderSaveAfter constructor.
     * @param EventEmitter $eventEmitter
     * @param EventInterface $eventToEmit
     */
    public function __construct(EventEmitter $eventEmitter, EventInterface $eventToEmit)
    {
        $this->eventEmitter = $eventEmitter;
        $this->eventToEmit = $eventToEmit;
    }

    /**
     * Send data to ESB schedule after invoice register.
     *
     * @param Observer $observer
     * @return void
     * @throws Exception
     */
    public function execute(Observer $observer)
    {
        /** @var Shipment $shipment */
        $shipment = $observer->getEvent()->getShipment();
        $this->eventEmitter->emit($this->eventToEmit, $shipment);
    }
}
