<?php

namespace FiloBlu\Esb\Model\Producer;

use FiloBlu\Esb\Api\Data\MessageInterface;
use FiloBlu\Esb\Api\Data\StatusInterface;
use FiloBlu\Esb\Core\Extractor\ObjectTypeFromMessage;
use Magento\Customer\Model\Backend\Customer;
use Magento\Framework\DataObject;
use Magento\Customer\Api\Data\CustomerInterface;

/**
 * Class CustomerSaveAfterProducer
 * @package FiloBlu\Esb\Model\Producer
 */
class CustomerSaveAfterProducer extends AbstractCustomerProducer
{

    /**
     * @inheritDoc
     */
    public function produce($customer = null): MessageInterface
    {
        /** @var MessageInterface $message */
        $message = $this->getMessageFactory()->create();

        if ($customer === null || !$this->isConditionSatisfied($this->prepareDataForEvaluation($customer))) {
            $this->getStatus()->setCode(StatusInterface::SKIPPED)->setOutputData(
                    $customer === null ? 'Customer was null' : 'Condition was not satisfied'
                );
            return $message;
        }

        $parameters = $this->getConfiguration()->getParameters();

        if ($customer !== null && $parameters->hasData(self::PAYLOAD_KEY)) {
            $template = $parameters->getData(self::PAYLOAD_KEY);
            $this->messageFiller->fill($message, $this->getDataForFiller($customer), $template);
        }

        $message->getPayload()->addData([
            ObjectTypeFromMessage::OBJECT_TYPE_PATH => $this->getObjectTypeDescriptor()->getTypeCode(),
            ObjectTypeFromMessage::OBJECT_ID_PATH => $customer->getId()
        ]);

        $this->getStatus()->setCode(StatusInterface::SUCCESS);

        return $message;
    }

    /**
     * @param CustomerInterface|Customer $customer
     * @return DataObject
     */
    protected function prepareDataForEvaluation($customer = null): DataObject
    {
        /** @var DataObject $dataToEvaluate */
        $dataToEvaluate = $this->dataObjectFactory->create();

        if ($customer === null) {
            return $dataToEvaluate;
        }

        $customer_data = $customer->__toArray();
        $customer_orig_data = $customer_data['orig_data'];

        $dataToEvaluate->setData('data', $customer_data);
        $dataToEvaluate->setData('origdata', $customer_orig_data ?: $this->dataObjectFactory->create());
        return $dataToEvaluate;
    }

    /**
     * @param CustomerInterface|Customer $customer
     * @return mixed
     */
    protected function getDataForFiller($customer)
    {
        $customer_data = $customer->__toArray();
        $customer_orig_data = $customer_data['orig_data'];

        return $this->dataObjectFactory->create(
            [
                'data' => [
                    'data' => $customer_data,
                    'origdata' => $customer_orig_data ?: $this->dataObjectFactory->create()
                ]
            ]
        );
    }

    /**
     * @inheritDoc
     */
    public function getName(): string
    {
        return 'Customer Save After Producer';
    }

    /**
     * @inheritDoc
     */
    public function getUniqueName(): string
    {
        return 'FiloBlu_Esb::customer_save_after';
    }
}
