<?php

namespace FiloBlu\Esb\Model\ObjectType;

use FiloBlu\Esb\Api\Data\ObjectTypeInterface;

/**
 * Class ObjectType
 * @package FiloBlu\Esb\Model\ObjectType
 */
class ObjectType implements ObjectTypeInterface
{
    /**
     * @var string
     */
    protected $typeCode;
    /**
     * @var string|null
     */
    protected $id;

    /**
     * ObjectType constructor.
     * @param string $typeCode
     * @param string $id
     */
    public function __construct($typeCode, $id = null)
    {
        $this->id = $id;
        $this->typeCode = $typeCode;
    }

    /**
     * @inheritDoc
     */
    public function getTypeCode(): string
    {
        return $this->typeCode;
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @inheritDoc
     */
    public function setId($id)
    {
        $this->id = $id;
    }
}
