<?php

namespace FiloBlu\Esb\Model;

use FiloBlu\Esb\Api\Data\EventConfigurationInterface;
use FiloBlu\Esb\Api\Data\EventInterface;
use FiloBlu\Esb\Api\Data\IdentifiableInterface;
use FiloBlu\Esb\Core\Id\UUID4GeneratorInterface;

/**
 * Class EventConfiguration
 * @package FiloBlu\Esb\Model
 */
class EventConfiguration implements EventConfigurationInterface
{
    /**
     * @var string
     */
    protected $eventCode;

    /**
     * @var EventInterface
     */
    protected $baseEvent;
    /**
     * @var string
     */
    protected $uuid;

    /**
     * @var int
     */
    protected $id;

    /**
     * @var UUID4GeneratorInterface
     */
    protected $UUID4Generator;

    /**
     * @var string
     */
    protected $label = '';

    /**
     * EventConfiguration constructor.
     * @param UUID4GeneratorInterface $UUID4Generator
     */
    public function __construct(UUID4GeneratorInterface $UUID4Generator)
    {
        $this->UUID4Generator = $UUID4Generator;
    }

    /**
     * @inheritDoc
     */
    public function getEventCode()
    {
        return $this->eventCode;
    }

    /**
     * @inheritDoc
     */
    public function setEventCode(string $eventCode): EventConfigurationInterface
    {
        $this->eventCode = $eventCode;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getBaseEvent(): EventInterface
    {
        return $this->baseEvent;
    }

    /**
     * @inheritDoc
     */
    public function setBaseEvent(EventInterface $baseEvent): EventConfigurationInterface
    {
        $this->baseEvent = $baseEvent;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getUuid(): string
    {
        return $this->uuid ?: $this->UUID4Generator->generate();
    }

    /**
     * @inheritDoc
     */
    public function setUuid($uuid): IdentifiableInterface
    {
        $this->uuid = $uuid;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @inheritDoc
     */
    public function setId($id): IdentifiableInterface
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getLabel(): string
    {
        return $this->label;
    }

    /**
     * @inheritDoc
     */
    public function setLabel(string $label): EventConfigurationInterface
    {
        $this->label = $label;
        return $this;
    }
}
