<?php

namespace FiloBlu\Esb\Model\Endpoints;

use FiloBlu\Esb\Api\ConsumerConfigurationRepositoryInterface;
use FiloBlu\Esb\Api\Data\ConsumerConfigurationInterface;
use FiloBlu\Esb\Api\Data\ProducerConfigurationInterface;
use FiloBlu\Esb\Api\ProducerConfigurationRepositoryInterface;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class Options
 * @package FiloBlu\Esb\Model\Producer
 */
class Options implements OptionSourceInterface
{
    /**
     * @var array
     */
    protected $options = [];

    /**
     * @var ProducerConfigurationRepositoryInterface
     */
    private $producerConfigurationRepository;
    /**
     * @var ConsumerConfigurationRepositoryInterface
     */
    private $consumerConfigurationRepository;

    /**
     * Options constructor.
     * @param ProducerConfigurationRepositoryInterface $producerConfigurationRepository
     * @param ConsumerConfigurationRepositoryInterface $consumerConfigurationRepository
     */
    public function __construct(
        ProducerConfigurationRepositoryInterface $producerConfigurationRepository,
                                ConsumerConfigurationRepositoryInterface $consumerConfigurationRepository
    ) {
        $this->producerConfigurationRepository = $producerConfigurationRepository;
        $this->consumerConfigurationRepository = $consumerConfigurationRepository;
    }

    /**
     * @return array|null
     */
    public function toOptionArray()
    {
        if (empty($this->options)) {
            $this->options[] = [
                'value' => null,
                'label' => 'None'
            ];

            $result = $this->producerConfigurationRepository->getList();

            /** @var ProducerConfigurationInterface $item */
            foreach ($result->getItems() as $item) {
                $this->options[] = [
                    'value' => $item->getUuid(),
                    'label' => $item->getLabel()
                ];
            }

            $result = $this->consumerConfigurationRepository->getList();

            /** @var ConsumerConfigurationInterface $item */
            foreach ($result->getItems() as $item) {
                $this->options[] = [
                    'value' => $item->getUuid(),
                    'label' => $item->getLabel()
                ];
            }
        }
        return $this->options;
    }
}
