<?php

namespace FiloBlu\Esb\Framework\Template;

use Magento\Framework\DataObject;

/**
 * Interface TemplateInterface
 * @package FiloBlu\Esb\Framework\Template
 */
interface TemplateInterface
{
    /**
     * @param array $variables
     * @return TemplateInterface
     */
    public function setVariables(array $variables): TemplateInterface;

    /**
     * @param string $name
     * @param $value
     * @return TemplateInterface
     */
    public function setVariable(string $name, $value) : TemplateInterface;

    /**
     * @param array $template
     * @return TemplateInterface
     */
    public function setTemplate(array $template): TemplateInterface;

    /**
     * @return DataObject
     */
    public function render(): DataObject;
}
