<?php
declare(strict_types=1);

namespace FiloBlu\Esb\Core\Expression\Operator;

/**
 * Class GreatThanOperator
 * @package FiloBlu\Esb\Core\Expression\Operator
 */
class GreatThanOperator implements OperatorInterface
{
    /**
     * @return string
     */
    public function getSymbol()
    {
        return 'gt';
    }

    /**
     * @param $leftOperand
     * @param $rightOperand
     * @return bool
     */
    public function execute($leftOperand, $rightOperand): bool
    {
        return $leftOperand > $rightOperand;
    }
}
