<?php
declare(strict_types=1);

namespace FiloBlu\Esb\Core\Expression\Operator;

/**
 * Class GreatEqualThanOperator
 * @package FiloBlu\Esb\Core\Expression\Operator
 */
class GreatEqualThanOperator implements OperatorInterface
{

    /**
     * @return string|void
     */
    public function getSymbol()
    {
        return 'gte';
    }

    /**
     * @param $leftOperand
     * @param $rightOperand
     * @return bool
     */
    public function execute($leftOperand, $rightOperand): bool
    {
        return $leftOperand >= $rightOperand;
    }
}
