<?php

namespace FiloBlu\Esb\Block\Adminhtml\Queue\View;

use FiloBlu\Esb\Block\Adminhtml\Common\Button;

/**
 * Class BackButton
 */
class ResumeButton extends Button
{

    /**
     * @return array
     */
    public function getButtonData()
    {
        if ($this->getId() === null) {
            return [];
        }

        return [
            'label' => __('Resume'),
            'class' => 'action-secondary',
            'on_click' => 'confirmSetLocation(\''
                . __('Are you sure you want to resume this item ?')
                . '\', \'' . $this->getUrl('*/*/resume', ['id' => $this->getId()]) . '\')',
            'sort_order' => 20,
        ];
    }

    /**
     * @return string
     */
    protected function getId()
    {
        return $this->context->getRequest()->getParam('id', null);
    }
}
