<?php

namespace FiloBlu\Esb\Block\Adminhtml\Event;

use FiloBlu\Esb\Api\EventResolverInterface;
use Magento\Backend\Block\Widget\Button\SplitButton;
use Magento\Backend\Block\Widget\Container;
use Magento\Backend\Block\Widget\Context;
use Magento\Framework\Api\SimpleDataObjectConverter;

/**
 * Class EventSplitButton
 * @package FiloBlu\Esb\Block\Adminhtml\Event
 */
class EventSplitButton extends Container
{
    /**
     * @var EventResolverInterface
     */
    private $eventResolver;

    /**
     * @param Context $context
     * @param EventResolverInterface $eventResolver
     * @param array $data
     */
    public function __construct(
        Context $context,
        EventResolverInterface $eventResolver,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->eventResolver = $eventResolver;
    }

    /**
     * @return Container
     */
    protected function _prepareLayout()
    {
        $this->buttonList->add('add_new', [
            'id' => 'filoblu_esb_create_event',
            'label' => __('Add Event'),
            'class' => 'add',
            'button_class' => '',
            'class_name' => SplitButton::class,
            'options' => $this->getEventList(),
        ]);

        return parent::_prepareLayout();
    }

    /**
     * @return array
     */
    protected function getEventList(): array
    {
        $list = [];
        $i = 0;
        foreach ($this->eventResolver->getAll() as $objectType) {
            $list["create_event_{$i}"] = [
                'label' => __($objectType->getName()),
                'onclick' => 'setLocation("' . $this->getUrl('*/*/edit', ['type' => $objectType->getUniqueName()]) . '")'];
            $i++;
        }

        return $list;
    }
}
