<?php

namespace FiloBlu\Esb\Api\Data;

use FiloBlu\Esb\Api\ObjectTypeLoaderInterface;
use FiloBlu\Esb\Api\ObjectTypeSaverInterface;
use FiloBlu\Esb\Api\RetryStrategyInterface;
use Magento\Framework\DataObject;

/**
 * Interface ConfigurationInterface
 * @package FiloBlu\Esb\Api\Data
 */
interface ConsumerConfigurationInterface extends RepositoryItem, IdentifiableInterface
{
    /** @var integer */
    const STATUS_ENABLED = 1;
    /** @var integer */
    const STATUS_DISABLED = 0;

    /** @var string */
    const CONSUMER = 'consumer';
    /** @var string */
    const OUTPUT_EVENT = 'output_event';
    /** @var string */
    const BINDING_EVENT = 'binding_event';
    /** @var string */
    const PARAMETERS = 'parameters';
    /** @var string */
    const ENABLE = 'enable';
    /** @var string */
    const RETRY_STRATEGY = 'retry_strategy';
    /** @var string */
    const LABEL = 'label';
    /** @var string */
    const SAVE_REQUEST = 'save_request';
    /** @var string */
    const SAVE_RESPONSE = 'save_response';
    /** @var string */
    const PRIORITY = 'priority';
    /** @var string */
    const RETRY_STRATEGY_CONFIGURATION = 'retry_strategy_configuration';
    /** @var string */
    const OBJECT_LOADER = 'object_loader';
    /** @var string */
    const OBJECT_SAVER = 'object_saver';
    /** @var string  */
    const TRIGGER_DELAY = 'trigger_delay';

    /**
     * @return string
     */
    public function getOutputEvent(): string;

    /**
     * @return string
     */
    public function getBindingEvent(): string;

    /**
     * @return DataObject
     */
    public function getParameters(): DataObject;

    /**
     * @param $event
     * @return ConsumerConfigurationInterface
     */
    public function setOutputEvent($event): ConsumerConfigurationInterface;

    /**
     * @param $event
     * @return ConsumerConfigurationInterface
     */
    public function setBindingEvent($event): ConsumerConfigurationInterface;

    /**
     * @param DataObject $parameters
     * @return ConsumerConfigurationInterface
     */
    public function setParameters(DataObject $parameters): ConsumerConfigurationInterface;

    /**
     * @return ConsumerInterface
     */
    public function getConsumer() : ConsumerInterface;

    /**
     * @param ConsumerInterface $consumer
     * @return ConsumerConfigurationInterface
     */
    public function setConsumer(ConsumerInterface $consumer): ConsumerConfigurationInterface;

    /**
     * @return string
     */
    public function getLabel(): string;

    /**
     * @param string $label
     * @return ConsumerConfigurationInterface
     */
    public function setLabel(string $label): ConsumerConfigurationInterface;

    /**
     * @return bool
     */
    public function isEnabled(): bool;

    /**
     * @return mixed
     */
    public function enable();

    /**
     * @return mixed
     */
    public function disable();

    /**
     * @return RetryStrategyInterface
     */
    public function getRetryStrategy(): RetryStrategyInterface;

    /**
     * @param RetryStrategyInterface $retryStrategy
     * @return ConsumerConfigurationInterface
     */
    public function setRetryStrategy(RetryStrategyInterface $retryStrategy): ConsumerConfigurationInterface;

    /**
     * @param $configuration
     * @return ConsumerConfigurationInterface
     */
    public function setRetryStrategyConfiguration($configuration): ConsumerConfigurationInterface;

    /**
     * @return mixed
     */
    public function getRetryStrategyConfiguration();

    /**
     * @param bool $save
     * @return ConsumerConfigurationInterface
     */
    public function setSaveRequest(bool $save): ConsumerConfigurationInterface;

    /**
     * @return bool
     */
    public function getSaveRequest(): bool;

    /**
     * @param bool $save
     * @return ConsumerConfigurationInterface
     */
    public function setSaveResponse(bool $save): ConsumerConfigurationInterface;

    /**
     * @return bool
     */
    public function getSaveResponse(): bool;

    /**
     * @param int $priority
     * @return ConsumerConfigurationInterface
     */
    public function setPriority($priority): ConsumerConfigurationInterface;

    /**
     * @return int
     */
    public function getPriority(): int;

    /**
     * @param ObjectTypeLoaderInterface $objectTypeLoader
     * @return ConsumerConfigurationInterface
     */
    public function setObjectLoader(ObjectTypeLoaderInterface $objectTypeLoader): ConsumerConfigurationInterface;

    /**
     * @return ObjectTypeLoaderInterface
     */
    public function getObjectLoader(): ObjectTypeLoaderInterface;

    /**
     * @param ObjectTypeSaverInterface $objectTypeSaver
     * @return ConsumerConfigurationInterface
     */
    public function setObjectSaver(ObjectTypeSaverInterface $objectTypeSaver): ConsumerConfigurationInterface;

    /**
     * @return ObjectTypeSaverInterface
     */
    public function getObjectSaver(): ObjectTypeSaverInterface;

    /**
     * @return int
     */
    public function getTriggerDelay();

    /**
     * @param int $triggerDelay
     * @return ConsumerConfigurationInterface
     */
    public function setTriggerDelay($triggerDelay) : ConsumerConfigurationInterface;
}
