<?php
/**
 * Copyright © 2016 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\Esb\Plugin\OrderPlace;

use FiloBlu\Esb\Api\Data\EventInterface;
use FiloBlu\Esb\Framework\Event\EventEmitter;

/**
 * Plugin that extends OrderManagement. Sends data on order place.
 */
class Plugin
{
    /**
     * @var EventEmitter
     */
    private $eventEmitter;
    /**
     * @var EventInterface
     */
    private $eventToEmit;

    /**
     * OrderSaveAfter constructor.
     * @param EventEmitter $eventEmitter
     * @param EventInterface $eventToEmit
     */
    public function __construct(EventEmitter $eventEmitter, EventInterface $eventToEmit)
    {
        $this->eventEmitter = $eventEmitter;
        $this->eventToEmit = $eventToEmit;
    }

    /**
     * Send data to ESB schedule after order place.
     *
     * @param $interceptor
     * @param $order
     * @return mixed
     * @throws \Exception
     */
    public function afterPlace($interceptor, $order)
    {
        $this->eventEmitter->emit($this->eventToEmit, $order);
        return $order;
    }
}
