<?php

namespace FiloBlu\Esb\Model\Producer;

use FiloBlu\Esb\Api\Data\MessageInterface;
use FiloBlu\Esb\Api\Data\StatusInterface;
use FiloBlu\Esb\Framework\Producer\AbstractProducer;
use Magento\Framework\DataObject;
use Magento\Sales\Api\Data\OrderInterface;

/**
 * Class AnyProducer
 * @package FiloBlu\Esb\Model\Producer
 */
class FormProducer extends AbstractProducer
{
    /**
     * @return string
     */
    public function getName(): string
    {
        return 'Form producer';
    }

    /**
     * @return string
     */
    public function getUniqueName(): string
    {
        return 'FiloBlu_Esb::form_producer';
    }

    /**
     * @param null $data
     * @return MessageInterface
     */
    public function produce($data = null): MessageInterface
    {
        /** @var MessageInterface $message */
        $message = $this->getMessageFactory()->create();
        $payload = $this->dataObjectFactory->create(['data' => $data]);

        if ($data === null || !$this->isConditionSatisfied($payload)) {
            $this->getStatus()
                ->setCode(StatusInterface::SKIPPED)
                ->setOutputData($data === null ? 'Payload was null' : 'Condition was not satisfied');
            return $message;
        }

        $this->getStatus()->setCode(StatusInterface::SUCCESS);

        return $message->setPayload($payload);
    }
}
