<?php

namespace FiloBlu\Esb\Model\Loader;

use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\Data\ObjectTypeInterface;
use FiloBlu\Esb\Api\ObjectTypeLoaderInterface;
use FiloBlu\Esb\Framework\ObjectType\Endpoint\AbstractEndpoint;
use stdClass;

/**
 * Class NullLoader
 * @package FiloBlu\Esb\Model\Loader
 */
class NullLoader extends AbstractEndpoint implements ObjectTypeLoaderInterface
{

    /**
     * @inheritDoc
     */
    public function getName(): string
    {
        return 'None';
    }

    /**
     * @inheritDoc
     */
    public function getUniqueName(): string
    {
        return 'FiloBlu_Esb::null_loader';
    }

    /**
     * @inheritDoc
     */
    public function get(ObjectTypeInterface $objectType)
    {
        return new stdClass();
    }

    /**
     * @inheritDoc
     */
    public function isSuitableFor(ObjectTypeDescriptorInterface $objectTypeDescriptor): bool
    {
        return true;
    }
}
