<?php

namespace FiloBlu\Esb\Model;

use FiloBlu\Esb\Api\Data\EventInterface;
use FiloBlu\Esb\Api\EventResolverInterface;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Class EventResolver
 * @package FiloBlu\Esb\Model
 */
class EventResolver implements EventResolverInterface
{
    /**
     * @var array
     */
    protected $events;

    /**
     * EventResolver constructor.
     * @param array $events
     */
    public function __construct(array $events)
    {
        $this->events = $events;
    }

    /**
     * @inheritDoc
     */
    public function getAll(): array
    {
        return $this->events;
    }

    /**
     * @inheritDoc
     */
    public function get($name): EventInterface
    {
        /** @var EventInterface $instance */
        foreach ($this->events as $instance) {
            if ($instance->getUniqueName() === $name) {
                return $instance;
            }

        }

        throw new NoSuchEntityException(__('Could not find event with name or class "%1"', $name));
    }
}
