<?php
/**
* Copyright © 2016 Filoblu S.r.l. All rights reserved.
*/

namespace FiloBlu\Esb\Model;
use FiloBlu\Esb\Api\Data\AcknowledgeInterface;

/**
 * Class Acknowledge
 * @package FiloBlu\Esb\Model
 */
class Acknowledge extends \Magento\Framework\Model\AbstractModel implements \FiloBlu\Esb\Api\Data\AcknowledgeInterface{

  /**
  * Retrieve Status
  *
  * @return string
  */
  public function getStatus(){
    return $this->getData("status");
  }

  /**
  * Set Order Status
  *
  * @param string $data
  * @return $this
  */
  public function setStatus($data){
    $this->setData("status", $data);
    return $this;
  }

/**
  * Retrieve Code
  *
  * @return string
  */
  public function getCode(){
    return $this->getData("code");
  }

  /**
  * Set Order Code
  *
  * @param string $data
  * @return $this
  */
  public function setCode($data){
    $this->setData("code", $data);
    return $this;
  }


/**
  * Retrieve Message
  *
  * @return string
  */
  public function getMessage(){
    return $this->getData("message");
  }

  /**
  * Set Order Message
  *
  * @param string $data
  * @return $this
  */
  public function setMessage($data){
    $this->setData("message", $data);
    return $this;
  }


  /**
  * Retrieve Description
  *
  * @return string
  */
  public function getDescription(){
    return $this->getData("description");
  }

  /**
  * Set Order Description
  *
  * @param string $data
  * @return $this
  */
  public function setDescription($data){
    $this->setData("description", $data);
    return $this;
  }

  /**
  * Retrieve Flow
  *
  * @return string
  */
  public function getFlow(){
    return $this->getData("flow");
  }

  /**
  * Set Order Flow
  *
  * @param string $data
  * @return $this
  */
  public function setFlow($data){
    $this->setData("flow", $data);
    return $this;
  }

  /**
  * Retrieve Order Increment Id
  *
  * @return string
  */
  public function getOrderIncrementId(){
    return $this->getData("order_increment_id");
  }

  /**
  * Set Order Increment Id
  *
  * @param string $data
  * @return $this
  */
  public function setOrderIncrementId($data){
    $this->setData("order_increment_id", $data);
    return $this;
  }



}
