<?php
/**
 * Copyright © 2016 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\Esb\Helper\Format;

use Magento\Framework\App\Helper\AbstractHelper;

/**
 * Helper for formatting data in JSON
 */
class Json extends AbstractHelper implements FormatInterface
{

    /**
     * Formats data array in JSON
     *
     * @param array $data
     * @return string
     */
    public function format($data)
    {
        return json_encode($data);
    }

    /**
     * Get HTTP Content Type
     *
     * @return string
     */
    public function getContentType()
    {
        return 'application/json';
    }

}
