<?php

namespace FiloBlu\Esb\Cron;

use FiloBlu\Esb\Api\DispatcherInterface;
use FiloBlu\Esb\Api\DispatcherInterfaceFactory;

/**
 * Class Dispatch
 * @package FiloBlu\Esb\Cron
 */
class Dispatch
{

    /**
     * @var DispatcherInterfaceFactory
     */
    private $dispatcherFactory;

    /**
     * Dispatch constructor.
     * @param DispatcherInterfaceFactory $dispatcherFactory
     */
    public function __construct(DispatcherInterfaceFactory $dispatcherFactory)
    {
        $this->dispatcherFactory = $dispatcherFactory;
    }

    /**
     *
     */
    public function execute()
    {
        /** @var DispatcherInterface $dispatcher */
        $dispatcher = $this->dispatcherFactory->create();
        $dispatcher->dispatch();
    }
}