<?php
declare(strict_types=1);

namespace FiloBlu\Esb\Core\Expression\Operator;

/**
 * Class StrictEqualOperator
 * @package FiloBlu\Esb\Core\Expression\Operator
 */
class StrictEqualOperator implements OperatorInterface
{

    public function getSymbol()
    {
        return 'seq';
    }

    /**
     * @param $leftOperand
     * @param $rightOperand
     * @return bool
     */
    public function execute($leftOperand, $rightOperand) : bool
    {
        return $leftOperand === $rightOperand;
    }
}
