<?php
declare(strict_types=1);

namespace FiloBlu\Esb\Core\Expression\Operator;

/**
 * Class StartsWithOperator
 * @package FiloBlu\Esb\Core\Expression\Operator
 */
class StartsWithOperator implements OperatorInterface
{
    /**
     * @return string
     */
    public function getSymbol()
    {
        return 'startswith';
    }

    /**
     * @param $leftOperand
     * @param $rightOperand
     * @return bool
     */
    public function execute($leftOperand, $rightOperand): bool
    {
        return (substr($leftOperand, 0, strlen($rightOperand)) === $rightOperand);
    }
}
