<?php

namespace FiloBlu\Esb\Block\Adminhtml\Map;

use FiloBlu\Esb\Api\ConsumerConfigurationRepositoryInterface;
use FiloBlu\Esb\Api\EventConfigurationRepositoryInterface;
use FiloBlu\Esb\Api\ProducerConfigurationRepositoryInterface;
use Magento\Backend\Block\Template;

/**
 * Class Map
 * @package FiloBlu\Esb\Block\Adminhtml\Map
 */
class Map extends Template
{
    /**
     * @var EventConfigurationRepositoryInterface
     */
    private $eventRepository;
    /**
     * @var ProducerConfigurationRepositoryInterface
     */
    private $producerConfigurationRepository;
    /**
     * @var ConsumerConfigurationRepositoryInterface
     */
    private $consumerConfigurationRepository;

    /**
     * Map constructor.
     * @param EventConfigurationRepositoryInterface $eventRepository
     * @param ProducerConfigurationRepositoryInterface $producerConfigurationRepository
     * @param ConsumerConfigurationRepositoryInterface $consumerConfigurationRepository
     * @param Template\Context $context
     * @param array $data
     */
    public function __construct(
        EventConfigurationRepositoryInterface $eventRepository,
        ProducerConfigurationRepositoryInterface $producerConfigurationRepository,
        ConsumerConfigurationRepositoryInterface $consumerConfigurationRepository,
        Template\Context $context,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->eventRepository = $eventRepository;
        $this->producerConfigurationRepository = $producerConfigurationRepository;
        $this->consumerConfigurationRepository = $consumerConfigurationRepository;
    }

    /**
     * @return array
     */
    public function getEventList()
    {
        $out = [];
        $events = $this->eventRepository->getList(null, true)->getItems();
        foreach ($events as $event) {
            $out[] = $event['event_code'];
        }
        return $out;
    }

    /**
     * @return array
     */
    public function getProducerList()
    {
        return $this->producerConfigurationRepository->getList(null, true)->getItems();
    }

    /**
     * @return array
     */
    public function getConsumerList()
    {
        return $this->consumerConfigurationRepository->getList(null, true)->getItems();
    }
}
