<?php

namespace FiloBlu\Esb\Api;

use FiloBlu\Esb\Api\Data\ProducerConfigurationInterface;
use FiloBlu\Esb\Api\Data\ProducerInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Interface ProducerConfigurationRespositoryInterface
 * @package FiloBlu\Esb\Api
 */
interface ProducerConfigurationRepositoryInterface extends RepositoryInterface
{

    /**
     * @param ProducerConfigurationInterface $configuration
     * @return mixed
     */
    public function save(ProducerConfigurationInterface $configuration);

    /**
     * @param ProducerInterface|string $producer
     * @return ProducerConfigurationInterface
     * @throws NoSuchEntityException
     */
    public function getByProducer($producer): ProducerConfigurationInterface;

    /**
     * @param ProducerConfigurationInterface $configuration
     * @return mixed
     */
    public function delete(ProducerConfigurationInterface $configuration);

}
