<?php

namespace FiloBlu\Esb\Api\Data;

use DateTime;

/**
 * Interface QueueMetadataInterface
 * @package FiloBlu\Esb\Api\Data
 */
interface QueueMetadataInterface
{
    /** @var string */
    const PUBLISHED_AT = 'published_at';

    /** @var string */
    const EXECUTABLE_AFTER = 'executable_after';

    /** @var string */
    const EXECUTED_AT = 'executed_at';

    /** @var string */
    const FINISHED_AT = 'finished_at';

    /** @var string */
    const FROM = 'from';

    /** @var string */
    const TO = 'to';

    /**
     * @return string
     */
    public function getFrom(): string;

    /**
     * @return string
     */
    public function getTo(): string;

    /**
     * @return DateTime
     */
    public function getPublishedAt();

    /**
     * @return DateTime
     */
    public function getExecutableAfter();

    /**
     * @return DateTime
     */
    public function getExecutedAt();

    /**
     * @return DateTime
     */
    public function getFinishedAt();

    /**
     * @param $uuid
     * @return mixed
     */
    public function setFrom($uuid): QueueMetadataInterface;

    /**
     * @param $uuid
     * @return QueueMetadataInterface
     */
    public function setTo($uuid): QueueMetadataInterface;

    /**
     * @param DateTime|null $executableAfter
     * @return QueueItemInterface
     */
    public function setExecutableAfter(DateTime $executableAfter = null): QueueMetadataInterface;

    /**
     * @param DateTime|null $publishedAt
     * @return QueueItemInterface
     */
    public function setPublishedAt(DateTime $publishedAt = null): QueueMetadataInterface;

    /**
     * @param DateTime|null $executedAt
     * @return QueueItemInterface
     */
    public function setExecutedAt(DateTime $executedAt = null): QueueMetadataInterface;

    /**
     * @param DateTime $finishedAt
     * @return QueueItemInterface
     */
    public function setFinishedAt(DateTime $finishedAt = null): QueueMetadataInterface;
}
