<?php

namespace FiloBlu\Esb\Api\Data;

/**
 * Interface QueueItemInterface
 * @package FiloBlu\Esb\Api\Data
 */
interface QueueItemInterface extends QueueMetadataInterface, RepositoryItem
{
    /** @var string */
    const ID = 'queue_id';
    /** @var string */
    const PRIORITY = 'priority';
    /** @var string */
    const RETRY_COUNT = 'retry_count';
    /** @var string */
    const RETRY_ITEM_ID = 'retry_item_id';
    /** @var string */
    const EVENT = 'event';
    /** @var string */
    const STATUS = 'status';
    /** @var string */
    const MESSAGE = 'message';
    /** @var string  */
    const MESSAGE_HASH = 'message_hash';

    /**
     * @return int
     */
    public function getId();

    /**
     * @param int $id
     * @return QueueItemInterface
     */
    public function setId($id): QueueItemInterface;

    /**
     * @return int
     */
    public function getPriority();

    /**
     * @param int $priority
     * @return QueueItemInterface
     */
    public function setPriority($priority): QueueItemInterface;

    /**
     * @return string
     */
    public function getEvent();

    /**
     * @param string $event
     * @return QueueItemInterface
     */
    public function setEvent($event): QueueItemInterface;

    /**
     * @return int
     */
    public function getRetryCount(): int;

    /**
     * @param $count
     * @return QueueItemInterface
     */
    public function setRetryCount($count): QueueItemInterface;

    /**
     * @return int
     */
    public function getRetryItemId(): int;

    /**
     * @param int $id
     * @return QueueItemInterface
     */
    public function setRetryItemId($id): QueueItemInterface;

    /**
     * @param StatusInterface $status
     * @return QueueItemInterface
     */
    public function setStatus(StatusInterface $status): QueueItemInterface;

    /**
     * @return StatusInterface
     */
    public function getStatus();

    /**
     * @param MessageInterface $message
     * @return QueueItemInterface
     */
    public function setMessage(MessageInterface $message): QueueItemInterface;

    /**
     * @return MessageInterface
     */
    public function getMessage();

    /**
     * @return string
     */
    public function getMessageHash();

    /**
     * @param string|null $hash
     * @return \FiloBlu\Esb\Api\Data\QueueItemInterface
     */
    public function setMessageHash($hash): QueueItemInterface;

}
