<?php

namespace FiloBlu\Esb\Api\Data;

/**
 * Interface ConsumerInterface
 * @package FiloBlu\Esb\Api\Data
 */
interface ConsumerInterface extends ObjectTypeEndpointInterface
{
    /**
     * @param ConsumerConfigurationInterface $configuration
     * @return ConsumerInterface
     */
    public function configure(ConsumerConfigurationInterface $configuration): ConsumerInterface;

    /**
     * @return ConsumerConfigurationInterface
     */
    public function getConfiguration(): ConsumerConfigurationInterface;

    /**
     * @param MessageInterface $message
     * @return MessageInterface
     */
    public function consume(MessageInterface $message): MessageInterface;

    /**
     * @return StatusInterface
     */
    public function getStatus() : StatusInterface;
}
