<?php

/**
 * Copyright © 2016 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\Esb\Api\Data;
/**
 * Interface AcknowledgeInterface
 * @package FiloBlu\Esb\Api\Data
 */
interface AcknowledgeInterface
{

    /**
     * Retrieve Status
     *
     * @return string
     */
    public function getStatus();

    /**
     * Set Status
     *
     * @param string $data
     * @return \FiloBlu\Esb\Api\Data\AcknowledgeInterface
     */
    public function setStatus($data);

    /**
     * Retrieve Code
     *
     * @return string
     */
    public function getCode();

    /**
     * Set Code
     *
     * @param string $data
     * @return \FiloBlu\Esb\Api\Data\AcknowledgeInterface
     */
    public function setCode($data);

    /**
     * Retrieve Message
     *
     * @return string
     */
    public function getMessage();

    /**
     * Set Message
     *
     * @param string $data
     * @return \FiloBlu\Esb\Api\Data\AcknowledgeInterface
     */
    public function setMessage($data);

    /**
     * Retrieve Description
     *
     * @return string
     */
    public function getDescription();

    /**
     * Set Description
     *
     * @param string $data
     * @return \FiloBlu\Esb\Api\Data\AcknowledgeInterface
     */
    public function setDescription($data);

    /**
     * Retrieve Flow
     *
     * @return string
     */
    public function getFlow();

    /**
     * Set Flow
     *
     * @param string $data
     * @return \FiloBlu\Esb\Api\Data\AcknowledgeInterface
     */
    public function setFlow($data);

    /**
     * Retrieve Order Increment Id
     *
     * @return string
     */
    public function getOrderIncrementId();

    /**
     * Set Order Increment Id
     *
     * @param string $data
     * @return \FiloBlu\Esb\Api\Data\AcknowledgeInterface
     */
    public function setOrderIncrementId($data);
}
