<?php

declare(strict_types=1);

namespace FiloBlu\Core\Test\Unit\Framework\Model\Mail;

use Magento\Framework\TestFramework\Unit\Helper\ObjectManager;
use PHPUnit\Framework\TestCase;

/**
 * Class MessageTest
 * @package FiloBlu\Core\Test\Unit\Framework\Model\Mail
 */
class MessageTest extends TestCase
{
    /** @var ObjectManager */
    private $objectManager;

    /** @var \FiloBlu\Core\Framework\Model\Mail\Message */
    private $message;

    /**
     * @dataProvider mailSetToProvider
     */
    public function testSetTo($intial, $email, $expected)
    {
        $this->message->setTo($intial);
        $result = $this->message->setTo($email);

        $this->assertEquals($this->message, $result);
        $this->assertEquals($expected, $this->message->getTo());
    }

    /**
     * @dataProvider mailAddToProvider
     */
    public function testAddTo($intial, $email, $expected)
    {
        $this->message->setTo($intial);
        $result = $this->message->addTo($email);

        $this->assertEquals($this->message, $result);
        $this->assertEquals($expected, $this->message->getTo());
    }


    public function testSetters()
    {
        $value = 'value';
        $arrayValue = [$value];

        $result = $this->message->setFrom($value);
        $this->assertEquals($this->message, $result);
        $this->assertEquals($value, $this->message->getFrom());

        $result = $this->message->setReplyTo($value);
        $this->assertEquals($this->message, $result);
        $this->assertEquals($value, $this->message->getReplyTo());

        $result = $this->message->setStoreId($value);
        $this->assertEquals($this->message, $result);
        $this->assertEquals($value, $this->message->getStoreId());

        $result = $this->message->setTemplate($value);
        $this->assertEquals($this->message, $result);
        $this->assertEquals($value, $this->message->getTemplate());

        $result = $this->message->setTemplateVariables($arrayValue);
        $this->assertEquals($this->message, $result);
        $this->assertEquals($arrayValue, $this->message->getTemplateVariables());

        $result = $this->message->setTemplateOptions($arrayValue);
        $this->assertEquals($this->message, $result);
        $this->assertEquals($arrayValue, $this->message->getTemplateOptions());

        $result = $this->message->setBcc($arrayValue);
        $this->assertEquals($this->message, $result);
        $this->assertEquals($arrayValue, $this->message->getBcc());

        $result = $this->message->setCC($arrayValue);
        $this->assertEquals($this->message, $result);
        $this->assertEquals($arrayValue, $this->message->getCC());

        $result = $this->message->setAttachments($arrayValue);
        $this->assertEquals($this->message, $result);
        $this->assertEquals($arrayValue, $this->message->getAttachments());

        $result = $this->message->enableTranslation(true);
        $this->assertEquals($this->message, $result);
        $this->assertTrue($this->message->canTranslate());
    }

    public function mailSetToProvider()
    {
        return [
            // from empty
            // initial value expeted
            [[], 1, []],
            [[], null, []],
            [[], new \stdClass(), []],
            [[], 'email@test.com', ['email@test.com']],
            [[], ['email@test.com'], ['email@test.com']],
            // from inizialized
            // initial value expeted
            [['oldemail@test.com'], 1, ['oldemail@test.com']],
            [['oldemail@test.com'], null, ['oldemail@test.com']],
            [['oldemail@test.com'], new \stdClass(), ['oldemail@test.com']],
            [['oldemail@test.com'], 'email@test.com', ['email@test.com']],
            [['oldemail@test.com'], ['email@test.com'], ['email@test.com']]
        ];
    }

    public function mailAddToProvider()
    {
        return [
            // from empty
            // initial value expeted
            [[], 1, []],
            [[], null, []],
            [[], new \stdClass(), []],
            [[], 'email@test.com', ['email@test.com']],
            [[], ['email@test.com'], ['email@test.com']],
            // from inizialed
            // initial value expeted
            [['oldemail@test.com'], 1, ['oldemail@test.com']],
            [['oldemail@test.com'], null, ['oldemail@test.com']],
            [['oldemail@test.com'], new \stdClass(), ['oldemail@test.com']],
            [['oldemail@test.com'], 'email@test.com', ['oldemail@test.com', 'email@test.com']],
            [['oldemail@test.com'], ['email@test.com'], ['oldemail@test.com', 'email@test.com']]
        ];
    }

    protected function setUp(): void
    {
        if ($this->objectManager === null) {
            $this->objectManager = new ObjectManager($this);
        }

        $this->message = $this->objectManager->getObject(\FiloBlu\Core\Framework\Model\Mail\Message::class);
    }
}
