<?php

declare(strict_types=1);

namespace FiloBlu\Core\Test\Draft;


use FiloBlu\Core\Framework\Model\Mail\MessageInterface;
use FiloBlu\Core\Model\Mail\Mailer;
use Magento\Framework\App\Area;
use Magento\Framework\App\Bootstrap;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\App\State;

require __DIR__ . '/../../../../../app/bootstrap.php';
$params = $_SERVER;
$bootstrap = Bootstrap::create(BP, $params);
$obj = $bootstrap->getObjectManager();
$state = $obj->get(State::class);
$state->setAreaCode('adminhtml');
$objectManager = ObjectManager::getInstance();

/** @var  MessageInterface $mailMessage */
$mailMessage = $objectManager->create(MessageInterface::class);

/** @var Mailer $mailer */
$mailer = $objectManager->get(Mailer::class);

$mailMessage
    ->setStoreId(1)
    ->setTemplate('filoblu_core_plain_frontend_template')
    ->setTemplateOptions([
        'area'  => Area::AREA_FRONTEND,
        'store' => 'it'
    ])
    ->setTemplateVariables(
        [
            'store'   => 'it',
            'subject' => 'Test Mail',
            'message' => 'Test Message'
        ]
    )
    ->setReplyTo('stefano.pallozzi@filoblu.com')
    //->setBcc(["bcc@example.com"])
    //->setCc(["cc@example.com"])
    ->setFrom('noreply@kimbo.it')
    ->setTo(['stefano.pallozzi@filoblu.com'])
    ->enableTranslation(true)
    ->setAttachments([realpath('./test.pdf')]);
$mailer->send($mailMessage);

