<?php

use FiloBlu\Core\Framework\Model\Mail\MessageInterface;
use FiloBlu\Core\Model\Mail\Mailer;
use Magento\Framework\App\Area;
use Magento\Framework\App\Bootstrap;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\App\State;

require __DIR__ . '/../../../../../app/bootstrap.php';
$params = $_SERVER;
$bootstrap = Bootstrap::create(BP, $params);
$obj = $bootstrap->getObjectManager();
$state = $obj->get(State::class);
$state->setAreaCode('adminhtml');
$objectManager = ObjectManager::getInstance();

/** @var  MessageInterface $mailMessage */
$mailMessage = $objectManager->create(MessageInterface::class);

/** @var Mailer $mailer */
$mailer = $objectManager->get(Mailer::class);
/** @var \Magento\Store\Model\StoreManagerInterface $storeManager */
$storeManager = $objectManager->get(\Magento\Store\Model\StoreManagerInterface::class);

$storeIt = $storeManager->getStore('it');

$mailMessage
    ->setStoreId($storeIt->getStoreId())
    ->setTemplate('filoblu_core_plain_frontend_template')
    ->setTemplateOptions([
        'area'  => Area::AREA_FRONTEND,
        'store' => 'it'
    ])
    ->setTemplateVariables(
        [
            'store'   => $storeIt,
            'subject' => 'Test Mail',
            'message' => 'Test Message'
        ]
    )
//    ->setReplyTo('stefano.pallozzi@smartwool.co.uk')
  //  ->setBcc(["bcc@example.com"])
    //->setCc(["cc@example.com"])
    ->setFrom('no-reply@smartwool.co.uk')
    ->setTo(['stefano.pallozzi@filoblu.com']);

$mailer->send($mailMessage);
