<?php
/**
 * Copyright © 2016 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\Core\Setup;

use FiloBlu\Core\Api\Data\FbOrderExtensionAttrInterface;
use FiloBlu\Core\Model\FbOrderExtensionAttrRepository;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;
use Zend_Db_Exception;

class UpgradeSchema implements UpgradeSchemaInterface
{

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     * @throws Zend_Db_Exception
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        if (version_compare($context->getVersion(), '1.0.1') < 0) {
            $this->createFilobluOrderExtensionAttributesTable($setup);
        }
        if (version_compare($context->getVersion(), '1.0.2') < 0) {
            $this->addShippingDocFilobluOrderExtensionAttribute($setup);
        }
        if (version_compare($context->getVersion(), '1.0.3') < 0) {
            $this->addFilobluOrderExtensionAttributesTableConstraints($setup);
        }
        $setup->endSetup();
    }

    /**
     * @param SchemaSetupInterface $setup
     * @throws Zend_Db_Exception
     */
    public function createFilobluOrderExtensionAttributesTable(SchemaSetupInterface $setup)
    {
        $tableName = $setup->getTable(FbOrderExtensionAttrRepository::TABLE_NAME);

        if ($setup->getConnection()->isTableExists($tableName)) {
            return;
        }

        $table = $setup->getConnection()
            ->newTable($tableName)
            ->addColumn(
                'fborderextensionattr_id',
                Table::TYPE_INTEGER,
                null,
                [
                    'identity' => true,
                    'unsigned' => true,
                    'nullable' => false,
                    'primary' => true
                ]
            )
            ->addColumn(
                'order_id',
                Table::TYPE_INTEGER,
                null,
                [
                    'identity' => false,
                    'unsigned' => true,
                    'nullable' => false,
                    'primary' => false
                ],
                'Sales Order Entity ID'
            )
            ->addColumn(
                'preprinted_rma_tracking_code',
                Table::TYPE_TEXT,
                255,
                ['nullable' => true, 'default' => null],
                'RMA tracking code preprinted'
            )
            ->addForeignKey(
                $setup->getFkName(
                    'fb_extensionattributes_order',
                    'order_id',
                    'sales_order',
                    'entity_id'
                ),
                'order_id',
                $setup->getTable('sales_order'),
                'entity_id',
                Table::ACTION_CASCADE
            )
            ->setComment('Table where to save all the Filoblu extension attributes of the order entity')
            ->setOption('type', 'InnoDB')
            ->setOption('charset', 'utf8');
        $setup->getConnection()->createTable($table);
    }

    public function addShippingDocFilobluOrderExtensionAttribute(SchemaSetupInterface $setup)
    {
        $tableName = $setup->getTable(FbOrderExtensionAttrRepository::TABLE_NAME);

        if (!$setup->tableExists($tableName)) {
            return;
        }

        $setup->getConnection()
            ->addColumn(
                $setup->getTable($tableName),
                'shipping_document_url',
                [
                    'type' => Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'shipping_document_url',
                    'after' => 'preprinted_rma_tracking_code'
                ]
            );

        $setup->getConnection()
            ->addColumn(
                $setup->getTable($tableName),
                'shipping_document_payload',
                [
                    'type' => Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'shipping_document_payload',
                    'after' => 'shipping_document_url'
                ]
            );
    }

    /**
     * @param SchemaSetupInterface $setup
     * @return void
     */
    public function addFilobluOrderExtensionAttributesTableConstraints(SchemaSetupInterface $setup)
    {
        $tableName = $setup->getTable(FbOrderExtensionAttrRepository::TABLE_NAME);
        $setup->getConnection()->addIndex(
            $tableName,
            $setup->getIdxName($tableName, FbOrderExtensionAttrInterface::ORDER_ID),
            FbOrderExtensionAttrInterface::ORDER_ID,
            AdapterInterface::INDEX_TYPE_UNIQUE);
    }
}
