<?php

namespace FiloBlu\Core\Setup;

use Exception;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\StatusFactory;

/**
 * Class InstallData
 * @package FiloBlu\Esb\Setup
 */
class InstallData implements InstallDataInterface
{
    /**
     * @var StatusFactory
     */
    protected $statusFactory;

    /**
     * InstallData constructor.
     * @param StatusFactory $statusFactory
     */
    public function __construct(
        StatusFactory $statusFactory
    )
    {
        $this->statusFactory = $statusFactory;
    }

    /**
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     * @throws Exception
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        $setup->endSetup();
    }
}
