<?php
declare(strict_types=1);

namespace FiloBlu\Core\Plugin;

use FiloBlu\Core\Model\Locator\Quote;

class QuoteLocatorProvider
{
    /**
     * @var Quote
     */
    private $locator;

    /**
     * @param Quote $locator
     */
    public function __construct(
        Quote $locator
    )
    {
        $this->locator = $locator;
    }

    public function afterGet(\Magento\Quote\Model\QuoteRepository $subject, $resultQuote, $quoteId)
    {
        $this->locator->setQuote($resultQuote);
        return $resultQuote;
    }
}
