<?php

namespace FiloBlu\Core\Plugin\Magento\Webapi\Model\Soap;

use Magento\Framework\App\AreaList;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Config\ScopeInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\Store;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Webapi\Controller\PathProcessor;

/**
 * Plugin needed to fix SOAP WSDL urls
 * https://your.magento.host/soap/all?wsdl_list=1
 */
class Server
{

    /**
     * @var AreaList
     */
    protected $areaList;
    /**
     * @var ScopeInterface
     */
    protected $scopeInterface;
    /**
     * @var StoreManagerInterface
     */
    protected $storeManagerInterface;
    /**
     * @var RequestInterface
     */
    protected $requestInterface;

    /**
     * Server constructor.
     * @param AreaList $areaList
     * @param ScopeInterface $scopeInterface
     * @param StoreManagerInterface $storeManagerInterface
     * @param RequestInterface $requestInterface
     */
    public function __construct(
        AreaList              $areaList,
        ScopeInterface        $scopeInterface,
        StoreManagerInterface $storeManagerInterface,
        RequestInterface      $requestInterface)
    {
        $this->areaList = $areaList;
        $this->scopeInterface = $scopeInterface;
        $this->storeManagerInterface = $storeManagerInterface;
        $this->requestInterface = $requestInterface;
    }

    /**
     * @param \Magento\Webapi\Model\Soap\Server $subject
     * @param $result
     * @return string
     * @throws NoSuchEntityException
     */
    public function afterGetEndpointUri(\Magento\Webapi\Model\Soap\Server $subject, $result)
    {

        $frontName = $this->areaList->getFrontName($this->scopeInterface->getCurrentScope());
        // Not in SOAP scope? Do nothing!
        if ($frontName !== 'soap') {
            return $result;
        }

        // Stripping store code from base url
        $currentStoreCode = $this->storeManagerInterface->getStore()->getCode();
        $baseUrl = $this->storeManagerInterface->getStore()->getBaseUrl();
        $strippedStoreCodeBaseUrl = str_replace("/{$currentStoreCode}", '', $baseUrl);

        // StoreCode of original getEndpointUri function
        $storeCode = $this->storeManagerInterface->getStore()->getCode() === Store::ADMIN_CODE ? PathProcessor::ALL_STORE_CODE : $this->storeManagerInterface->getStore()->getCode();

        // Rebuild
        return "{$strippedStoreCodeBaseUrl}{$frontName}/{$storeCode}";
    }
}
