<?php

namespace FiloBlu\Core\Plugin\Block;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\Store;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Class Index
 * @package FiloBlu\Core\Plugin\Block
 */
class Index
{

    /**
     * @var RequestInterface
     */
    protected $request;
    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * Index constructor.
     * @param RequestInterface $request
     * @param ScopeConfigInterface $scopeConfig
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        RequestInterface $request,
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager
    ) {
        $this->request = $request;
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
    }

    /**
     * @param $subject
     * @param $result
     * @return string|null
     * @throws NoSuchEntityException
     */
    public function afterGetSchemaUrl($subject, $result)
    {
        if ($result === null) {
            return null;
        }

        $path = $this->request->isSecure() ?
            Store::XML_PATH_SECURE_BASE_URL :
            Store::XML_PATH_UNSECURE_BASE_URL;

        return str_replace(
            $this->storeManager->getStore()->getBaseUrl(),
            $this->scopeConfig->getValue($path, 'store'),
            $result
        );
    }
}
