<?php
declare(strict_types=1);

namespace FiloBlu\Core\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

/**
 * Class BeforeSendResponseObserver
 * @package FiloBlu\Core\Observer
 */
class BeforeSendResponseObserver implements ObserverInterface
{
    /**
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        $response = $observer->getEvent()->getResponse();
        $html = $response->getBody();

        if (stripos($html, '<!DOCTYPE html') === false) {
            return;
        }

        $headers = $response->getHeaders()->toArray();

        if (array_key_exists('Content-Type', $headers) && $headers['Content-Type'] === 'application/json') {
            return;
        }

        $found = preg_match('/(<\/head\s?+>)\s?+<body/im', $html, $matches, PREG_OFFSET_CAPTURE);

        if ($found) {
            $replacement = "\n<!-- TEST CIAO -->\n{$matches[1][0]}\n";
            $html = substr_replace($html, $replacement, $matches[1][1], strlen($matches[1][0]));
        }

        $response->setBody($html);
    }
}
