<?php

namespace FiloBlu\Core\Model\XmlCatalog\Format;

use DOMDocument;
use DOMImplementation;
use Magento\Developer\Model\XmlCatalog\Format\FormatInterface;
use Magento\Framework\DomDocument\DomDocumentFactory;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Filesystem\DriverPool;
use Magento\Framework\Filesystem\File\WriteFactory;

/**
 * Class Xsd
 * @package FiloBlu\Core\Model\XmlCatalog\Format
 */
class Xsd implements FormatInterface
{
    /**
     * @var WriteFactory
     */
    protected $fileWriteFactory;

    /**
     * @var DomDocumentFactory
     */
    protected $domDocumentFactory;

    /**
     * Xsd constructor.
     * @param WriteFactory $fileWriteFactory
     * @param DomDocumentFactory $domDocumentFactory
     */
    public function __construct(
        WriteFactory $fileWriteFactory,
        DomDocumentFactory $domDocumentFactory
    ) {
        $this->fileWriteFactory = $fileWriteFactory;
        $this->domDocumentFactory = $domDocumentFactory;
    }

    /**
     * @inheritDoc
     * @throws FileSystemException
     */
    public function generateCatalog(array $dictionary, $configFile)
    {
        $file = $this->fileWriteFactory->create(
            $configFile,
            DriverPool::FILE,
            'w'
        );

        $implementation = new DOMImplementation();

        $type = $implementation->createDocumentType(
            'catalog',
            '-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN',
            'http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd'
        );

        $dom = $implementation->createDocument('', '', $type);
        $dom->encoding = 'UTF-8';
        $dom->formatOutput = true;
        $catalog = $dom->createElement('catalog');
        $catalog->setAttribute('xmlns', 'urn:oasis:names:tc:entity:xmlns:xml:catalog');

        foreach ($dictionary as $urn => $xsdPath) {
            $node = $dom->createElement('uri');
            $node->setAttribute('name', $urn);
            $node->setAttribute('uri', "file://{$xsdPath}");
            $catalog->appendChild($node);
        }

        $dom->appendChild($catalog);
        $file->write($dom->saveXML());
        $file->close();

        $file = $this->fileWriteFactory->create(
            dirname($configFile) . '/all.xsd',
            DriverPool::FILE,
            'w'
        );

        $fullSchema = new DOMDocument('1.0', 'UTF-8');

        $schema = $fullSchema->createElement('xs:schema');
        $schema->setAttribute('xmlns:xs', 'http://www.w3.org/2001/XMLSchema');

        foreach ($dictionary as $urn => $xsdPath) {
            $node = $fullSchema->createElement('xs:include');
            $node->setAttribute('schemaLocation', $urn);
            $schema->appendChild($node);
        }
        $fullSchema->appendChild($schema);
        $fullSchema->formatOutput = true;
        $file->write($fullSchema->saveXML());
        $file->close();
    }
}
