<?php

namespace FiloBlu\Core\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Data\OptionSourceInterface;
use Magento\Framework\Mail\EmailMessageInterface;
use Magento\Framework\Mail\MessageInterface;
use Magento\Framework\Mail\TransportInterface;
use Magento\Framework\ObjectManagerInterface;

/**
 * Class Transport
 * @package FiloBlu\Core\Model
 */
class Transport implements TransportInterface, OptionSourceInterface
{

    /**
     * XML PATH
     */
    const XML_MAIL_TRANSPORT = 'filoblu_mail/mail/transport';
    /**
     * @var MessageInterface
     */
    protected $message;
    /**
     * @var array
     */
    protected $transport;
    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;
    /**
     * @var ObjectManagerInterface
     */
    protected $objectManager;

    /**
     * Transport constructor.
     * @param $message
     * @param ScopeConfigInterface $scopeConfig
     * @param ObjectManagerInterface $objectManager
     * @param array $transport
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        ObjectManagerInterface $objectManager,
        $message = null,
        array $transport = []
    )
    {
        $this->transport = $transport;
        $this->scopeConfig = $scopeConfig;

        $this->message = $message;
        $this->objectManager = $objectManager;
    }

    /**
     * Send Message
     */
    public function sendMessage()
    {
        $this->objectManager->create(
            $this->transport[$this->getTransport()]['class'],
            ['message' => $this->message]
        )->sendMessage();
    }

    /**
     * @return string
     */
    public function getTransport()
    {
        $transport = $this->scopeConfig->getValue(self::XML_MAIL_TRANSPORT);
        return ($transport != null) ? $transport : 'magento_transport';
    }

    /**
     * @return MessageInterface
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $returnArray = [];
        foreach ($this->transport as $key => $transport) {
            $returnArray[] = ['value' => $key, 'label' => $transport['label']];
        }
        return $returnArray;
    }
}
