<?php

namespace FiloBlu\Core\Model\StoreCalculator;

use FiloBlu\Core\Api\StoreCalculatorInterface;
use Magento\Store\Api\Data\StoreInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;


class StoreCalculatorFromCountry implements StoreCalculatorInterface
{

    /**
     * @var StoreManagerInterface
     */
    protected $storeManagerInterface;

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * StoreCalculatorFromCountry constructor.
     * @param StoreManagerInterface $storeManagerInterface
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        StoreManagerInterface $storeManagerInterface,
        ScopeConfigInterface $scopeConfig
    )
    {
        $this->storeManagerInterface = $storeManagerInterface;
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @inheritDoc
     */
    public function calculate($object) : StoreInterface {

        $country_to_find = strtoupper($object);
        $websites = $this->storeManagerInterface->getWebsites();
        $core_config_paths_to_search = array("general/country/allow", "carriers/matrixrate/specificcountry");

        foreach ($core_config_paths_to_search as $path) {
            $found_in = array();
            foreach ($websites as $website) {
                $config_data = $this->scopeConfig->getValue($path, ScopeInterface::SCOPE_WEBSITES, $website->getId());
                if (empty($config_data)) {
                    continue;
                }
                $config_data = array_filter(explode(',', $config_data));
                if (in_array($country_to_find, $config_data)) {
                    $found_in[] = $website;
                }
            }
            if (count($found_in) == 1) {
                $website = $found_in[0];
                return $website->getDefaultStore();
            }
        }

        return $this->storeManagerInterface->getDefaultStoreView();
    }

    /**
     * @inheritDoc
     */
    public function canHandle($object) : bool{
        // Only ISO2 strings
        return gettype($object) === 'string' && strlen($object) == '2';
    }
}
