<?php

namespace FiloBlu\Core\Model\StoreCalculator;

use FiloBlu\Core\Api\StoreCalculatorInterface;
use Magento\Store\Api\Data\StoreInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;


class StoreCalculatorDefault implements StoreCalculatorInterface
{

    /**
     * @var StoreManagerInterface
     */
    protected $storeManagerInterface;

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * StoreCalculatorFromCountry constructor.
     * @param StoreManagerInterface $storeManagerInterface
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        StoreManagerInterface $storeManagerInterface,
        ScopeConfigInterface $scopeConfig
    )
    {
        $this->storeManagerInterface = $storeManagerInterface;
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @inheritDoc
     */
    public function calculate($object) : StoreInterface {
        return $this->storeManagerInterface->getDefaultStoreView();
    }

    /**
     * @inheritDoc
     */
    public function canHandle($object) : bool {
        return true;
    }
}
