<?php
declare(strict_types=1);

namespace FiloBlu\Core\Model\Serializer;

use InvalidArgumentException;

/**
 * @see https://devdocs.magento.com/guides/v2.4/extension-dev-guide/framework/serializer.html
 */
interface SerializerInterface
{
    /**
     * Serialize data into string
     *
     * @param string|int|float|bool|array|null $data
     * @return string|bool
     * @throws InvalidArgumentException
     */
    public function serialize($data);

    /**
     * Unserialize the given string
     *
     * @param string $string
     * @return string|int|float|bool|array|null
     * @throws InvalidArgumentException
     */
    public function unserialize($string);
}


