<?php

declare(strict_types=1);

namespace FiloBlu\Core\Model\Serializer;

use Magento\Framework\ObjectManagerInterface;

/**
 * @class Serializer
 * @package FiloBlu\Core\Model
 * @see https://devdocs.magento.com/guides/v2.4/extension-dev-guide/framework/serializer.html
 */
class Serializer implements SerializerInterface
{
    /**
     * @var SerializerInterface
     */
    protected $serializer;

    /**
     * @param ObjectManagerInterface $objectManager
     */
    public function __construct(ObjectManagerInterface $objectManager)
    {
        if (interface_exists(\Magento\Framework\Serialize\SerializerInterface::class)) {
            $this->serializer = $objectManager->create(\Magento\Framework\Serialize\SerializerInterface::class);
            return;
        }

        $this->serializer = $objectManager->create(PhpSerializer::class);
    }

    /**
     * @param array|bool|float|int|string|null $data
     * @return bool|string
     */
    public function serialize($data)
    {
        return $this->serializer->serialize($data);
    }

    /**
     * @param string $string
     * @return array|bool|float|int|string|null
     */
    public function unserialize($string)
    {
        return $this->serializer->unserialize($string);
    }

}
