<?php
declare(strict_types=1);

namespace FiloBlu\Core\Model\Serializer;

use function serialize;
use function unserialize;

/**
 *
 */
class PhpSerializer implements SerializerInterface
{

    /**
     * Serialize data into string
     *
     * @param string|int|float|bool|array|null $data
     * @return string|bool
     * @throws InvalidArgumentException
     */
    public function serialize($data)
    {
        return serialize($data);
    }

    /**
     * Unserialize the given string
     *
     * @param string $string
     * @return string|int|float|bool|array|null
     * @throws InvalidArgumentException
     */
    public function unserialize($string)
    {
        return unserialize($string);
    }
}